/** ---------------------------
  * Robotran - MBsysC
  * 
  * Template file for direct dynamics module
  * 
  * This files enable the user to call custom at
  * specific places in the time simulation. It is a template
  * file that can be edited by the user.
  * 
  * (c) Universite catholique de Louvain
  *     
  */

#define _USE_MATH_DEFINES  // to use M_PI in Windows
#include "math.h"

#include "mbs_data.h"
#include "mbs_dirdyn_struct.h"

#include "set_output.h"
#include "user_all_id.h"
#include "mbs_sensor.h"

/*! \brief user own initialization functions
 * 
 * \param[in,out] mbs_data data structure of the model
 * \param[in,out] mbs_dd general structure of the direct dynamic module (for advance users)
 *
 * For beginners, it is advised to only use the MbsData structure.
 * The field MbsDirdyn is provided for more advance users.
 */
void user_dirdyn_init(MbsData *mbs_data, MbsDirdyn *mbs_dd)
{
    define_output_vector("Vector_Acc", 3);
    define_output_vector("Vector_Ver", 3);
}

/*! \brief user own loop functions
 * 
 * \param[in,out] mbs_data data structure of the model
 * \param[in,out] mbs_dd general structure of the direct dynamic module (for advance users)
 *
 * For beginners, it is advised to only use the MbsData structure.
 * The field MbsDirdyn is provided for more advance users.
 */
void user_dirdyn_loop(MbsData *mbs_data, MbsDirdyn *mbs_dd)
{
    int id = RodSensor_id;

    // retrieve the pointer to the sensor structure defined in mbs_aux
    MbsSensor *PtrSensor = mbs_dd->mbs_aux->psens;

    // compute the sensor (position, velocity...)
    mbs_comp_S_sensor(PtrSensor, mbs_data, id);

    // save only the vertical acceleration
    set_output(PtrSensor->A[3], "Vertical_Acc");
    // save all acceleration vector
    set_output_vector(&PtrSensor->A[1], "Vector_Acc");
    // save all vertical information (q, qd, qdd) of the vector
    set_output_value(PtrSensor->P[3], 1, "Vector_Ver");
    set_output_value(PtrSensor->V[3], 2, "Vector_Ver");
    set_output_value(PtrSensor->A[3], 3, "Vector_Ver");
}

/*! \brief user own finishing functions
 * 
 * \param[in,out] mbs_data data structure of the model
 * \param[in,out] mbs_dd general structure of the direct dynamic module (for advance users)
 *
 * For beginners, it is advised to only use the MbsData structure.
 * The field MbsDirdyn is provided for more advance users.
 */
void user_dirdyn_finish(MbsData *mbs_data, MbsDirdyn *mbs_dd)
{

}
